/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.registry.minecraft;

import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistries;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistry;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;
import tech.thatgravyboat.ironchests.api.chesttype.ChestUpgradeType;
import tech.thatgravyboat.ironchests.common.items.DollyItem;
import tech.thatgravyboat.ironchests.common.items.KeyItem;
import tech.thatgravyboat.ironchests.common.items.KeyRingItem;
import tech.thatgravyboat.ironchests.common.items.LockItem;
import tech.thatgravyboat.ironchests.common.items.UpgradeItem;
import tech.thatgravyboat.ironchests.common.registry.custom.ChestTypeRegistry;
import tech.thatgravyboat.ironchests.common.registry.custom.ChestUpgradeTypeRegistry;

public class ItemRegistry {
    public static final ResourcefulRegistry<Item> ITEMS = ResourcefulRegistries.create((Registry)Registry.f_122827_, (String)"ironchests");
    public static final Supplier<Item> BLANK_UPGRADE = ITEMS.register("blank_chest_upgrade", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final Supplier<Item> LOCK = ITEMS.register("lock", () -> new LockItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final Supplier<Item> KEY = ITEMS.register("key", () -> new KeyItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final Supplier<Item> KEY_RING = ITEMS.register("key_ring", () -> new KeyRingItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final Supplier<Item> DIAMOND_DOLLY = ITEMS.register("diamond_dolly", () -> new DollyItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_).m_41487_(1)));
    public static final Supplier<Item> IRON_DOLLY = ITEMS.register("iron_dolly", () -> new DollyItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_).m_41503_(15)));

    public static void init() {
        ChestTypeRegistry.INSTANCE.getChests().forEach(ItemRegistry::registerChest);
        ChestUpgradeTypeRegistry.INSTANCE.getUpgrades().forEach(ItemRegistry::registerUpgrade);
        ITEMS.init();
    }

    private static void registerChest(String id, ChestType type) {
        ITEMS.register(id, () -> new BlockItem((Block)type.registries().getBlock().get(), ItemRegistry.getProps(type)));
    }

    private static Item.Properties getProps(ChestType type) {
        Item.Properties properties = new Item.Properties().m_41491_(CreativeModeTab.f_40750_);
        if (type.fireResistant()) {
            properties = properties.m_41486_();
        }
        return properties;
    }

    private static void registerUpgrade(ChestUpgradeType type) {
        ITEMS.register(type.to().name() + "_chest_upgrade", () -> new UpgradeItem(type, new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    }
}

